# VibeCheck for LinkedIn

**AI-powered LinkedIn post analyser. Scores credibility, practical value, engagement bait, and AI slop.**

A Chrome extension that adds a Side Panel to LinkedIn. Tap ⚡ on any post for an instant verdict — no API key, no setup required. The AI backend is provided by VibeCheck and runs via a Supabase edge function powered by Grok (xAI).

---

## Development setup

1. Clone the repo (or download the `vibecheck` folder).
2. Open Chrome → `chrome://extensions`
3. Enable **Developer mode** (top right toggle).
4. Click **Load unpacked** → select the `vibecheck` folder.
5. Navigate to [linkedin.com](https://www.linkedin.com).
6. Click the VibeCheck icon — the side panel opens.
7. Enter your email address to activate (free, no card required).
8. Tap ⚡ on any LinkedIn post to run a vibe check.

To reload after code changes: click the refresh icon on the extension card in `chrome://extensions`.

---

## Building the bundle

The background service worker is bundled with esbuild:

```
cd vibecheck
npm install
npm run build
```

This produces `background.bundle.js` from `background.js`. The bundle has no external dependencies — the Anthropic SDK is not used; all AI calls go through the Supabase edge function.

---

## Architecture

| Component | Role |
|---|---|
| `manifest.json` | MV3 manifest — permissions, icons, service worker |
| `background.bundle.js` | Service worker: opens side panel, relays messages, calls Supabase edge function |
| `content.js` | Injected into linkedin.com — injects ⚡ buttons, extracts post text/metadata |
| `sidepanel.html/js/css` | Side panel UI — activation, results, history |

**Data flow:** user taps ⚡ → `content.js` extracts post → `background.bundle.js` sends to Supabase edge function → Grok analyses → verdict returned to side panel.

---

## Troubleshooting

**Console noise on LinkedIn:** Messages like `chrome-extension://invalid/` or "React DevTools" are **not from VibeCheck**. They come from LinkedIn's own scripts or other extensions.

---

## Privacy

See the full privacy policy at [vibecheck-for-linkedin.vercel.app/privacy](https://vibecheck-for-linkedin.vercel.app/privacy).

**In brief:** an email address is collected at activation and stored in Supabase. Post content is sent to the Supabase edge function in transit only and is not logged or stored. Local vibe check history stays on-device.
